package gov.va.med.mhv.admin.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import gov.va.med.mhv.admin.model.UserCalView;

@Entity
@Table(name = "VIEW_API_REMINDER")
public class CalViewApiReminder implements Serializable {

	private static final long serialVersionUID = 3924915397628339865L;

	@Id
	@Column(name = "VIEW_API_REMINDER_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long viewApiReminderId;

	@Column(name = "OPLOCK")
	private Integer oplock;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "VIEW_ID")
	private UserCalView userCalView;

	@Column(name = "API_CAT_API_CAT_ID")
	private Long apiCatID;

	public Long getViewApiReminderId() {
		return viewApiReminderId;
	}

	public void setViewApiReminderId(Long viewApiReminderId) {
		this.viewApiReminderId = viewApiReminderId;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public UserCalView getUserCalView() {
		return userCalView;
	}

	public void setUserCalView(UserCalView userCalView) {
		this.userCalView = userCalView;
	}

	public Long getApiCatID() {
		return apiCatID;
	}

	public void setApiCatID(Long apiCatID) {
		this.apiCatID = apiCatID;
	}

}
